// Media module
#include "app.h"
#include <d3d8.h>
#include <d3dx8.h>

void (*renderMethod[10])() = {NULL};

extern IDirect3DVertexBuffer8 *VertexBuffer;
extern IDirect3DTexture8 *TexScreen;
extern IDirect3DDevice8 *Device;
extern int TexWidth;
extern int TexHeight;
extern bool RequestExit;
struct CustomVertex
{
	float x,y,z; // Vertex cordinates
	unsigned int colour;
	float u,v; // Texture coordinates
};
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1)
extern CustomVertex VertexList[4];
unsigned short *EmuScreen=NULL;
int EmuWidth = 320;
int EmuHeight = 224;
int MainWidth = 640;
int MainHeight = 480;
extern float zTop;
extern float zLeft;
extern float zBottom;
extern float zRight;
HWND FrameWnd=NULL;

extern int nDtosWidth;
extern int nDtosHeight; // screen size
extern int nDtosMemPitch; // Memory buffer pitch
extern unsigned char *DtosMem;

typedef unsigned char bool8;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef signed char int8;
typedef short int16;
typedef long int32;
typedef unsigned int uint32;

extern void AdvMame2x(const uint8 *srcPtr, uint32 srcPitch, uint8 *dstPtr, uint32 dstPitch,
							 int width, int height);
extern void SuperScale(unsigned short *src,unsigned int srcpitch,
					   unsigned short *dst,unsigned int dstpitch,
					   unsigned short width,unsigned short height);
extern void SuperScale75(unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned short width,unsigned short height);
extern void MakeVertexList();
extern int SoftwareFilter;

void NoFilter() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	int pitch = lock.Pitch;

	for(int i = 0; i < nDtosHeight; i++) {
		memcpy(&SurfBuf[i * pitch], &DtosMem[i * nDtosMemPitch], nDtosWidth * 2);
	}
	
	TexScreen->UnlockRect(0);
}

void FilterSuperScale() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	SuperScale((unsigned short*)DtosMem, nDtosMemPitch/2, (unsigned short*)SurfBuf, lock.Pitch, nDtosWidth, nDtosHeight);
	TexScreen->UnlockRect(0);
}

void FilterAdvancedMame() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	AdvMame2x((unsigned char*)DtosMem, nDtosMemPitch,
		(unsigned char*)SurfBuf, lock.Pitch, nDtosWidth, nDtosHeight);
	TexScreen->UnlockRect(0);
}

void Simple2x(unsigned char *srcPtr, unsigned int srcPitch, unsigned char * /* deltaPtr */,
			  unsigned char *dstPtr, unsigned int dstPitch, int width, int height)
{
	unsigned char *nextLine, *finish;
	nextLine = dstPtr + dstPitch;
	do {
		unsigned int *bP = (unsigned int *) srcPtr;
		unsigned int *dP = (unsigned int *) dstPtr;
		unsigned int *nL = (unsigned int *) nextLine;
		unsigned int currentPixel;
		finish = (unsigned char *) bP + ((width+2) << 1);
		currentPixel = *bP++;

		do {
			unsigned int color = currentPixel & 0xffff;
			color = color | (color << 16);
			*(dP) = color;
			*(nL) = color;
			color = currentPixel >> 16;
			color = color| (color << 16);      
			*(dP + 1) = color;
			*(nL + 1) = color;
			currentPixel = *bP++;
			dP += 2;
			nL += 2;
		} while ((unsigned char *) bP < finish);
		srcPtr += srcPitch;
		dstPtr += dstPitch << 1;
		nextLine += dstPitch << 1;
	}
	while (--height);
}

void FilterSimple2X() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	Simple2x(DtosMem, nDtosMemPitch, 0, SurfBuf, lock.Pitch, nDtosWidth, nDtosHeight);
	TexScreen->UnlockRect(0);
}

void FilterSuperScale75() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	SuperScale75((unsigned short*)DtosMem, nDtosMemPitch/2,
		(unsigned short*)SurfBuf, lock.Pitch, nDtosWidth, nDtosHeight);
	TexScreen->UnlockRect(0);
}

int TexScreenInit()
{
	TexWidth =1024;
	TexHeight=512;

	Device->CreateTexture(TexWidth,TexHeight,0,0,D3DFMT_R5G6B5,D3DPOOL_MANAGED,&TexScreen);
	if (TexScreen==NULL) return 1;

	return 0;
}

int TexScreenLinear()
{
	//NoFilter();
	FilterSuperScale();
	return 0;
}

int SetupMatrices()
{
	D3DXVECTOR3 eye ( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 look( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 up  ( 0.0f, 1.0f, 0.0f );
	D3DXMATRIX mat;
	float nudgex=0.0f,nudgey=0.0f;
	memset(&mat,0,sizeof(mat));
	mat.m[0][0]=mat.m[1][1]=mat.m[2][2]=mat.m[3][3]=1.0f;
	Device->SetTransform(D3DTS_WORLD,&mat);
	look.x=0;
	look.y=0;
	look.z=10.0f;
	nudgex=13.3333f/(float)(TexWidth << 1);
	nudgey=10.0000f/(float)(TexHeight << 1);
	eye.x +=nudgex; eye.y +=nudgey;
	look.x+=nudgex; look.y+=nudgey;
	D3DXMatrixLookAtLH(&mat,&eye,&look,&up);
	Device->SetTransform(D3DTS_VIEW,&mat);
	D3DXMatrixPerspectiveFovLH(&mat, 0.5f*3.14, 1.3333f, 0.2f, 1000.0f);
	Device->SetTransform(D3DTS_PROJECTION,&mat);
	return 0;
}


void InitRender() {
	renderMethod[0] = &NoFilter;
	renderMethod[1] = &FilterSuperScale;
	renderMethod[2] = &FilterAdvancedMame;
	renderMethod[3] = &FilterSimple2X;
	renderMethod[4] = &FilterSuperScale75;
}

int DirectScreen()
{
	if(RequestExit == true)
		return 0;
	
	Device->Clear(0, NULL, D3DCLEAR_TARGET,0, 0.0f, 0);
	SetupMatrices();
	MakeVertexList();
	(*renderMethod[SoftwareFilter])(); 
	unsigned char *lock=NULL;
	VertexBuffer->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
	memcpy(lock,VertexList,sizeof(VertexList));
	VertexBuffer->Unlock();
	Device->SetTexture(0,TexScreen);
	Device->SetStreamSource(0,VertexBuffer,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->Present(NULL,NULL,NULL,NULL);
	return 0;
	/*unsigned char *lock=NULL;
	VertexBuffer->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
	memcpy(lock,VertexList,sizeof(VertexList));
	VertexBuffer->Unlock();
	Device->SetTexture(0,TexScreen);
	Device->SetStreamSource(0,VertexBuffer,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
	TexScreenLinear();
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->Present(NULL,NULL,NULL,NULL);*/
}

void AudioInit() {
// Init Dsound
  nDSoundSamRate=22050;
  nDSoundFps=nAppVirtualFps;
  //if(!bDSoundOkay)
	//DSoundInit(); // (not critical if it fails)

  // ------- Set up Burn library sound ------------------------
  nBurnSoundRate=0; pBurnSoundOut=NULL; // Assume no sound
  if (bDSoundOkay)
  {
    nBurnSoundRate=nDSoundSamRate;
    nBurnSoundLen=nDSoundSegLen;
  }
}

extern void ResizeTexture();

int MediaInit()
{
  int nRet=0; static char szWinName[512]="";
  unsigned char* pSShot = NULL;
  pSShot = DtosMem;
  D3DLOCKED_RECT lock={0,NULL};
	unsigned char *SurfBuf=NULL;
	TexScreen->LockRect( 0, &lock, 0, 0L );
	SurfBuf = (unsigned char *)lock.pBits;
	int pitch = lock.Pitch;

	int q = 0;
	for(int i = 0; i < TexHeight/*nVidImageHeight*/; i++) {
		for(int j = 0; j < TexWidth * 4 /*nVidImageWidth*/; j+=4) {
			SurfBuf[(i * pitch) + j]     = 0;
			SurfBuf[(i * pitch) + j + 1] = 0;
			SurfBuf[(i * pitch) + j + 2] = 0;
			SurfBuf[(i * pitch) + j + 3] = 0;
		}
	}

	TexScreen->UnlockRect(0);
	SetupMatrices();
	MakeVertexList();
	
	Device->SetTexture(0,TexScreen);
	Device->SetStreamSource(0,VertexBuffer,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
  // Video is init later
  return 0;
}

int MediaExit()
{
  return 0;
}
